///////////////////////////////////////////////////////////////////////////////////////////////
//Main program
//Created: 12/16/04
//Last Update: x
///////////////////////////////////////////////////////////////////////////////////////////////

EvaluateScript("managers.js")
EvaluateScript("item_build.js")
EvaluateScript("log.js")
EvaluateScript("utility.js")
EvaluateScript("ship_battle.js")
EvaluateScript("ship.js")
EvaluateScript("ship_travel.js")
EvaluateScript("walk_travel.js")
EvaluateScript("menu_system.js")
EvaluateScript("menu_shipyard.js")
EvaluateScript("menu_shop.js")
EvaluateScript("menu_player.js")
EvaluateScript("walk_entitys.js")
EvaluateScript("menu_textbox.js")
EvaluateScript("world_generate.js")
EvaluateScript("text.js")
EvaluateScript("flags.js")
EvaluateScript("menu_main.js")
EvaluateScript("data.js")
EvaluateScript("menu_battle.js")

///////////////////////////////////////////////////////////////////////////////////////////////

GenerateShrooms("shrooms.png", "mushroom")
GenerateShrooms("shroomsd1.png", "mushroomd0-")
GenerateShrooms("shroomsd2.png", "mushroomd1-")
GenerateShrooms("shroomsl.png", "mushrooml")

var PLAYER_WALK_SPRITE = "blackfoot.rss"
const PLAYER_SHIP_SPRITE = "ship.rss"

///////////////////////////////////////////////////////////////////////////////////////////////

var k_up = KEY_UP
var k_down = KEY_DOWN
var k_left = KEY_LEFT
var k_right = KEY_RIGHT
var k_a = KEY_A
var k_b = KEY_S

var font = GetSystemFont()
var gSuspendMovement = false

var gPlayer_Gold = 50
var gPlayer_Level = 1
var gPlayer_Ship = -1
var gPlayer_Mushrooms = new Array()

var gTown_Mushrooms = new Array()

gTown_Mushrooms = new Array()

gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 1) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 3) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )

gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 3) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 0) )
gTown_Mushrooms.push( new ItemBuild_oBlock(0, 0, 3) )

var gColor_White = CreateColor(255,255,255)
var gColor_Red = CreateColor(255,0,0)
var gColor_Gray = CreateColor(128,128,128)

///////////////////////////////////////////////////////////////////////////////////////////////

function game()
{
	GameInitilization()
	
	/*for (var i = 0; i < 40; i++)
		{
			for (var i2 = 0; i2 < 10; i2++)
				gPlayer_Mushrooms.push( new ItemBuild_oBlock(0, 0, i2) )	
		}*/	

	/*UProcList.push(SProcPeople)
	UProcList.push(SProcInput)
	UProcList.push(SProcWind)
	
	RProcList.push(RenderWind)*/
	
	UProcList.push(UpdateMenus)
	RProcList.push(RenderMenus)			
	
	UProcList.push(ProcPeople)
	UProcList.push(ProcInput)
	
	//MenuTest()
	
	AddPlayerWalk(8, 8)

	MapEngine("intro.rmp", 60)
	
	//MapEngine("island1_richman2.rmp", 60)
	
	//MapEngine("world.rmp", 60)
}

///////////////////////////////////////////////////////////////////////////////////////////////

function Random(lo,hi)
{
	hi++
	var random = lo += Math.floor(Math.random() * (hi - lo));
	return random
}

///////////////////////////////////////////////////////////////////////////////////////////////

var gImageList = {}
function GetImage(filename) {
  if (!(filename in gImageList)) {
    gImageList[filename] = LoadImage(filename);    
  }
  return gImageList[filename];
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GenerateShrooms(base, format)
{
	var base_img = LoadSurface(base)
	
	var x, img;

	for (var i = 0; i < 10; i++)
		{
			img = base_img.cloneSection(i * 17, 0, 16, 16)		
			
			img.save(format+i+".png")
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GetMushroomTypePicture(type)
{
	return "mushroom"+type+".png"
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GetMushroomType(picture)
{
	switch (picture)
		{
			case "mushroom0.png":
				return 0
			break; case "mushroom1.png":
				return 1
			break; case "mushroom2.png":
				return 2
			break; case "mushroom3.png":
				return 3
			break; case "mushroom4.png":
				return 4
			break; case "mushroom5.png":
				return 5
			break; case "mushroom6.png":
				return 6
			break; case "mushroom7.png":
				return 7
			break; case "mushroom8.png":
				return 8
			break; case "mushroom9.png":
				return 9
			break;																				
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GetMushroomTypeDark1Picture(type)
{
	return "mushroomd0-"+type+".png"
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GetMushroomTypeDark2Picture(type)
{
	return "mushroomd1-"+type+".png"
}

///////////////////////////////////////////////////////////////////////////////////////////////

function GetMushroomTypeLinkedPicture(type)
{
	return "mushrooml"+type+".png"
}

function GetMushroomStats(mush)
{
	var b = 0

	if (mush.linked == true)
		b = 1

	switch (mush.type)
		{
			case 0:
				return new oMushroomStats(3, 1, 2, 1, 5, 1,b)
			break; case 1:
				return new oMushroomStats(1, 3, 2, 3, 7, 0,b)
			break; case 2:
				return new oMushroomStats(4, 4, 1, 3, 25, 3,b)
			break; case 3:
				return new oMushroomStats(5, 2, 1, 1, 20, 2,b)
			break; case 4:
				return new oMushroomStats(1, 10, 2, 2, 100, 7,b)
			break; case 5:
				return new oMushroomStats(7, 4, 5, 5, 50, 6,b)					
			break; case 6:
				return new oMushroomStats(5, 10, 5, 5, 65, 5,b)			
			break; case 7:
				return new oMushroomStats(1, 9, 5, 10, 500, 4,b)			
			break; case 8:
				return new oMushroomStats(7, 8, 4, 4, 150, 9,b)			
			break; case 9:
				return new oMushroomStats(10, 5, 5, 5, 200, 8,b)										
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function oMushroomStats(hp, cannon, speed, accuracy, value, opposite, bonus)
{
	this.hp = hp+bonus
	this.cannon = cannon+bonus
	this.speed = speed+bonus
	this.accuracy = accuracy+bonus
	this.value = value+bonus
	this.opposite = opposite
}

///////////////////////////////////////////////////////////////////////////////////////////////

function RemItem(Arr, Item)
{
	for (var i = 0; i < Arr.length; i++)
		{
			if (Arr[i] == Item) Arr.splice(i,1)
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function DoNothing() { }

function Clone(object) //much thanks to WIP for this handy piece of code.
{
var objectClone = new object.constructor();
for (var property in object)
	{
		objectClone[property] = object[property]
	}
return objectClone;
}

var gSound = LoadSound("blank.ogg")
var gSoundName

function PlaySound(snd)
{
	if (gSoundName != snd)
		{
			gSound.stop();
			gSound = LoadSound(snd)
			gSoundName = snd
			gSound.play(true)	
		}
}

var gSfx = LoadSound("blank.ogg")
var gSfxName

function PlaySfx(sfx)
{
	if (gSfxName != sfx || !gSfx.isPlaying())
		{
			gSfx.stop();
			gSfx = LoadSound(sfx)
			gSfxName = sfx
			gSfx.play(false)	
		}
}

function GameOver()
{
	var t = GetTime()
	
	var bg = LoadImage("gameover.png")
	
	PlaySound("blank.ogg")
	
	while (t+8000 > GetTime())
		{
			bg.blit(0,0)
			FlipScreen()
		}
		
	Exit()
}

/*
function test(x)
{
	this.x = x
	
	
	
	this.testie = new function ()
		{
			Abort(x)
		}

}

var t = new test(5)
t.testie()*/